function chris_pca

% CHRIS_PCA
% Normal (classic) PCA, run on a subset of data, as well as a subset of variables.
clear;

fileName = 'C:\Users\Arseny\Documents\6_Chris Classification\Classification Results v5.xlsx';
sheetNames = {'Subdata1','Subdata2'}; % 1 for few cells more variables; 2 is for few variables more cells
dataType = 1;

temp = xlsread(fileName, sheetNames{dataType});

if(dataType==1)
    varNames = {'Cm, pF',	'Rm, GOhm',	'Ra, MOhm',	'I_hold pA',	'Na start mV',	...
        'Na Amp pA',	'Kstable start mV',	'Kstable Amp pA',	'Ktrans start mV',	'Ktrans Amp pA',...
        'Step start pA',	'Step max pA',	'Step max Nspikes',	'1sp Spike mV',	'1sp Half-width ms',...
        '1sp Latency ms',	'Spike Reduct',	's2-s1 lat ms',	'Cos  best period, ms',	'Mean spikes / bump',...
        'Desens N bump max',	'Desens depth',	'Desens tau',	'Jitter',	'Burst Decay',...
        'Burst Max Q',	'Burst Optimal ISI'};
else
    varNames = {'Cm, pF',	'Rm, GOhm',	'Ra, MOhm',	'I_hold pA',	'Na start mV',...
        'Na Amp pA',	'Kstable start mV',	'Kstable Amp pA',	'Ktrans start mV',	'Ktrans Amp pA',...
        'Step start pA',	'Step max pA',	'Step max Nspikes',	'1sp Spike mV',	'Spike Reduct',...
        's2-s1 lat ms'};
end

temp = temp(4:end,:);   % Remove top (header) lines
id = temp(:,1);
q = zeros(size(id));
data = temp(:,2:end);
dMeans = mean(data);
dStd = std(data);
data = bsxfun(@plus,data,-dMeans);
data = bsxfun(@times,data,1./dStd);

[comps,scores,eigenvalues] = princomp(data);

% for(w=1:40)
%     data2(floor(rand(1)*numel(data2))) = NaN;
% end
% [ A, S, Mu, V, cv, hp, lc ] = pca_full(data2',3);
% 
% size(S')
% size(scores(:,1:3))
% figure; plotmatrix(scores(:,1:3),S');
% return

if(1)
    figure; %%% Scree-plot
    plot(eigenvalues,'bo-'); grid on; %%% Percent: 80, 20, 10 , 2 . The rest is noise
    xlabel('Component'); ylabel('Variance'); title(['Scree plot (dataset ' num2str(dataType) ')']);
    
        figure; %%% Scree-plot
    plot(eigenvalues/sum(eigenvalues),'bo-'); grid on; %%% Percent: 80, 20, 10 , 2 . The rest is noise
    xlabel('Component'); ylabel('Variance'); title(['Scree plot (dataset ' num2str(dataType) ')']);
    eigenvalues(1:3)/sum(eigenvalues)

    figure; % Variables-in-components
    enum(comps(:,1),comps(:,2),varNames);
    xlabel('Component 1'); ylabel('Component 2'); title(['Loads (dataset ' num2str(dataType) ')']);

    fprintf('%5s\t%7s\t%7s\t%7s\n','id','c1','c2','c3');
    fprintf('%5d\t%7f\t%7f\t%7f\n',[id scores(:,1:3)]');
end

% plotmatrixgui(data2,scores(:,1:5)); % My semi-useful type of plot
% plotmatrixgui(scores(:,1:5));

nClusters = 3;
cid = kmeans(scores,nClusters,'dist','sqeuclidean'); % sqeuclidean = default (actually)
figure; scatter3(scores(:,1),scores(:,2),scores(:,3),100,cid,'filled');
set(gca,'DataAspectRatio',[1 1 1]);
xlabel('Score 1'); ylabel('Score 2');  zlabel('Score 3');
%figure; clusterboxplot(scores(:,1:3),[],cid); clusterboxplot(scores(:,1:5),data,cid);

% figure;
% %plotmatrix(stage'+randn(size(stage'))*0.1,scores(:,1:5));
% clusterboxplot(stage'+randn(size(stage'))*0.1,scores(:,1:5),cid);

% figure;
% clusterboxplot(scores(:,1:5),data,cid);
end